﻿#include <iostream>
#include <algorithm>
#include <math.h>
#include <cmath>
#include <vector>
#include <set>
#include <map>
#include <cmath>
#include <iomanip>
#include <cassert>
#define all(a) a.begin(), a.end()
#define int long long

using namespace std;
typedef long long ll;
typedef long double db;

template<typename T>
istream& operator>>(istream& in, vector<T>& v) {
	for (auto& u : v) in >> u;
	return in;
}

template<typename T1, typename T2>
istream& operator>>(istream& in, pair<T1, T2>& p) {
	in >> p.first >> p.second;
	return in;
}

vector<int> fact(int n) {
	vector<int> div; int d;
	for (d = 1; d * d < n; ++d) {
		if (n % d == 0) {
			div.push_back(d);
			div.push_back(n / d);
		}
	}
	if (d * d == n) div.push_back(d);
	return div;
}

void solve() {
	int x, y; cin >> x >> y;
	if (y == x) {
		cout << "0\n";
		return;
	}
	auto div = fact(y - x);
	int ans = x - 1;
	for (auto d: div) {
		int k = d + 1;
		int t = (k * x - y) / (k - 1);
		assert((k * x - y) % (k - 1) == 0);
		if (t >= 0) ans = min(ans, t);
	}
	cout << ans << '\n';
}

signed main() {
	ios_base::sync_with_stdio(false); cin.tie(nullptr);
	int t; cin >> t;
	while (t--) solve();
}